﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using DataAccess;
using Ext.Net;

public partial class TBICDS : System.Web.UI.Page
{
   
    public bool bShowAlert;

    /// <summary>
    /// US:7254 show a 508 compliant warning banner when the user first visits the page
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_LoadComplete(object sender, EventArgs e)
    {
        if (bShowAlert)
        {
            string strMsg = "";
            strMsg += "This system is intended to be used by [authorized VA network users] for viewing and retrieving ";
            strMsg += "information only except as otherwise explicitly authorized.\r\n\r\n";

            strMsg += "VA information resides on and transmits through computer systems and networks funded by VA; ";
            strMsg += "all use is considered to be understanding and acceptance that there is no reasonable expectation ";
            strMsg += "of privacy for any data or transmissions on Government Intranet or Extranet (non-public) networks ";
            strMsg += "or systems.\r\n\r\n";

            strMsg += "All transactions that occur on this system and all data transmitted through this system are ";
            strMsg += "subject to review and action including (but not limited to) monitoring, recording, retrieving, ";
            strMsg += "copying, auditing, inspecting, investigating, restricting access, blocking, tracking, ";
            strMsg += "disclosing to authorized personnel, or any other authorized actions by all authorized VA and ";
            strMsg += "law enforcement personnel. All use of this system constitutes understanding and unconditional ";
            strMsg += "acceptance of these terms.\r\n\r\n";

            strMsg += "Unauthorized attempts or acts to either (1) access, upload, change, or delete information on this ";
            strMsg += "system, (2) modify this system, (3) deny access to this system, or (4) accrue resources for ";
            strMsg += "unauthorized use on this system are strictly prohibited. Such attempts or acts are subject to ";
            strMsg += "action that may result in criminal, civil, or administrative penalties. ";

            //taAlert.Text = strMsg;
            ucAppLogin.EnableControls(false);
            winAlert.Show();
            //winAlert.Focus();
            
        }
    }

  
    /// <summary>
    /// US:5348 page load of TBI CDS main page
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {
        //X.Mask.Hide();
      
        //only 5 params allowed on the query string duz and dfn
        if (Request.QueryString.Count == 5)
        {
            //get the dfn and duz from the query string
            //sanitize the values to prevent XSS from query string
            Master.DUZ = CDataUtils2.Sanitize(Request.QueryString[0].ToString());
            Master.DFN = CDataUtils2.Sanitize(Request.QueryString[1].ToString());
            Master.SRV = CDataUtils2.Sanitize(Request.QueryString[2].ToString());
            Master.PORT = CDataUtils2.Sanitize(Request.QueryString[3].ToString());
            //note: not using MREF right now
        }

        bShowAlert = (!IsPostBack);

        //pass the master to controls 
        ucAppLogin.Master = Master;

        //if we are not logged in, show and load the login control
        if (!Master.IsLoggedIn())
        {
            ucAppLogin.Visible = true;
            ucAppLogin.LoadControl();
        }
        else
        {
            ucAppLogin.Visible = false;
            if (Master.DFN != "")
            {
                //lookup the patient by DFN from MDWS and transfer to the central db
                //will redirect home if the lookup fails, user can then try to look the 
                //patient up manually. 
                //
                //BUG_LOOKUP
                //in testing it appears that this is being called twice.
                //commenting out 
                //Master.LookupPatientByDUZ(Master.DUZ, Master.DFN);
                return;
            }
         
        }

        if (!IsPostBack)
        {
            if (Master.IsLoggedIn())
            {
                Master.LogOff();
            }

            if (bShowAlert)
            {
                //winAlert.Focus();
            }
        }
    }

    //clicked the accept terms button
    protected void btnAcceptTerms_Click(object sender, EventArgs e)
    {
        ucAppLogin.EnableControls(true);
        winAlert.Close();
    }

}